/* Antarmuka dengan Sensor Gesture APDS 9960 - Trainer Internet of Things
 * Project : Mengontrol Lampu dengan Sensor Gesture
 * Created By Electins.id
 * https://www.electins.id | https://www.instagram.com/electins.id/
 */

// Library LCD 16x2 I2C
#include <Wire.h>
#include <LiquidCrystal_I2C.h>
// Library APDS9960
#include <SparkFun_APDS9960.h>

// Koneksi PIN APDS-9960 ke PIN NodeMCU
#define APDS9960_SDA  D2
#define APDS9960_SCL  D1
#define APDS9960_INT  D5

// LCD Objek dengan nama lcd, alamat I2C 0x27, karakter 16x2
LiquidCrystal_I2C lcd(0x27,16,2);

// Variabel Global APDS9960
SparkFun_APDS9960 apds = SparkFun_APDS9960();
volatile bool isr_flag = 0;

// Fungsi interupsi pada IRAM
void ICACHE_RAM_ATTR interruptRoutine();

// Variabel data lampu dan pin lampu
int pos = 0, lamp_pin[3] = {D0, D6, D7};
// Variabel status lampu
boolean lamp_state[3];
String state;

void setup() {
  // Serial Monitor pada baudrate 115200
  Serial.begin(115200);

  // Memulai komunikasi I2C
  Wire.begin(APDS9960_SDA,APDS9960_SCL);
  // Mengatur pin interrupt sebagai input
  pinMode(digitalPinToInterrupt(APDS9960_INT), INPUT);
  // Inisialisasi Interupsi
  attachInterrupt(digitalPinToInterrupt(APDS9960_INT), interruptRoutine, FALLING);
  // Inisialisasi APDS-9960
  apds.init();
  // Mengaktifkan mode gesture
  apds.enableGestureSensor(true);

  // Mengatur pin lampu sebagai output
  // dengan kondisi awal LOW
  for(int i=0; i<=2; i++){
    Serial.println(i);
    pinMode(lamp_pin[i], OUTPUT);
    digitalWrite(lamp_pin[i], LOW); 
  }
  
  lcd.init();       // Inisialisasi LCD
  lcd.backlight();  // Menyalakan Backlight LCD
  lcd.print("Trainer Kit IoT"); 
  delay(2000);      // Jeda tampilan teks pada LCD
  lcd.clear();      // Membersihkan tampilan LCD
}

void loop(){
  // Membaca status ISR (Interrupt Service Routine)
  // Menjalankan fungsi handleGesture()
  if(isr_flag == 1){
    detachInterrupt(digitalPinToInterrupt(APDS9960_INT));
    handleGesture();
    isr_flag = 0;
    attachInterrupt(digitalPinToInterrupt(APDS9960_INT), interruptRoutine, FALLING);
  }

  // mengatur variabel pos
  // Jika lebih dari 2 pos menjadi 0
  // Jika kurang dari 0 pos menjadi 2
  if(pos > 2) pos = 0;
  if(pos < 0) pos = 2;
  // Nyalakan dan matikan lampu
  // Sesuai pin pada variabel lampu_pin dengan indeks pos
  // Status pada variabel lamp_state dengan indeks pos
  digitalWrite(lamp_pin[pos],lamp_state[pos]);

  // Mencetak teks pada LCD
  lcd.setCursor(0 ,0); lcd.print("Lampu Gesture   ");
  lcd.setCursor(0 ,1); lcd.print("> Lampu");
  lcd.setCursor(8 ,1); lcd.print(pos+1);
  lcd.setCursor(9 ,1); lcd.print(":");
  lcd.setCursor(11,1); lcd.print(state);

  // Mengubah status lamp_state dengan teks
  if(lamp_state[pos] == true)  state = "ON ";
  if(lamp_state[pos] == false) state = "OFF";
}

// Fungsi InterruptRoutine
void interruptRoutine(){
  isr_flag = 1;
}

// Fungsi handeGesture
// Membaca arah gesture
// Mengatur variabel 'pos' dan 'lamp_state' dengan indeks pos
void handleGesture(){
    if (apds.isGestureAvailable()){
    switch (apds.readGesture()){
      case DIR_UP:
        lamp_state[pos] = true;
        Serial.println("ATAS");
        break;
      case DIR_DOWN:
        lamp_state[pos] = false;
        Serial.println("BAWAH");
        break;
      case DIR_LEFT:
        pos--;
        Serial.println("KIRI");
        break;
      case DIR_RIGHT:
        pos++;
        Serial.println("KANAN");
        break;
      default:
        Serial.println("TIDAK ADA");
    }
  }
}
